<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Minnow
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', get_post_format() );
				?>

			<?php endwhile; ?>

			<?php minnow_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- columns -->
    
    <div class="col-lg-2 col-md-2 col-sm-2 hidden-xs no-padding">

	   	<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<label>
				<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'minnow' ); ?></span>
				<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'minnow' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
			</label>
			
		</form>

	    <div id="sidebar" class="sidebar" role="complementary">
	    	<ul class="sidebar-categories">
				<?php wp_list_categories( array(
			        'orderby'    => 'name',
			        'show_count' => true,
			        'exclude'    => array( 1 ),
			        'hide_empty' => false,
			        'title_li'   => 'Top Categories'
			    ) ); ?>
			</ul>
			<ul class="sidebar-archives">
				<li class="archives-title">
				Archives
					<?php wp_get_archives( array(
				        'show_post_count' => true
				    ) ); ?>
			    </li>
			</ul>
		</div><!-- #sidebar -->
    </div>

<?php get_footer(); ?>
