<?php
/**
 * @package Minnow
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
    	
		<?php if ( 'link' == get_post_format() ) : ?>
			<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( minnow_get_link_url() ) ), '</a></h1>' ); ?>
		<?php else : ?>
			<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>
		<?php endif; ?>

		<?php if ( 'post' == get_post_type() ) : ?>
        
        <div class="author-meta">
        	<div class="author-pic">
        		<?php echo get_avatar( get_the_author_meta( 'ID' ), 64 ); ?>
        	</div>
			<div class="entry-meta">
				<?php minnow_posted_on(); ?>
			</div><!-- .entry-meta -->
        </div>

		<?php endif; ?>
        
        
        
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			/* translators: %s: Name of current post */
			the_content( sprintf(
				__( 'Continue Reading %s <span class="meta-nav">&gt;</span>', 'minnow' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );
		?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'minnow' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<div class="entry-meta-tags">
		<br />
		<p>Tags: <?php display_tags(); ?></p>
	</div><!-- .entry-meta-tags -->

	<div class="entry-format">
		<?php minnow_entry_format(); ?>
	</div>
</article><!-- #post-## -->
