<?php
/**
 * The template for displaying all single posts.
 *
 * @package Minnow
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<?php get_template_part( 'content', 'single' ); ?>
            
            
			<?php minnow_post_nav(); ?>

			<?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
			?>
			<div class="short-subscribe">
            	<?php echo do_shortcode( '[contact-form-7 id="25" title="Contact form 1"]' ); ?>
            </div>

		<?php endwhile; // end of the loop. ?>

		</main><!-- #main -->
	</div><!-- #primary -->
    </div><!-- columns -->
    
    <div class="col-lg-2 col-md-2 col-sm-2 hidden-xs no-padding">

	   	<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<label>
				<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'minnow' ); ?></span>
				<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'minnow' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
			</label>
			
		</form>

	    <div id="sidebar" class="sidebar" role="complementary">
	    	<ul class="sidebar-categories">
				<?php wp_list_categories( array(
			        'orderby'    => 'name',
			        'show_count' => true,
			        'exclude'    => array( 1 ),
			        'hide_empty' => false,
			        'title_li'   => 'Top Categories'
			    ) ); ?>
			</ul>
			<ul class="sidebar-archives">
				<li class="archives-title">
				Archives
					<?php wp_get_archives( array(
				        'show_post_count' => true
				    ) ); ?>
			    </li>
			</ul>
		</div><!-- #sidebar -->
    </div>

<?php get_footer(); ?>
