<?php
/**
 * The template for displaying search results pages.
 *
 * @package Minnow
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'minnow' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
			</header><!-- .page-header -->

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'content', 'search' );
				?>

			<?php endwhile; ?>

			<?php minnow_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->
	</div><!-- columns -->

	<div class="col-lg-2 col-md-2 col-sm-2 hidden-xs no-padding">

	   	<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<label>
				<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'minnow' ); ?></span>
				<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'minnow' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
			</label>
			
		</form>

	    <div id="sidebar" class="sidebar" role="complementary">
	    	<ul class="sidebar-categories">
				<?php wp_list_categories( array(
			        'orderby'    => 'name',
			        'show_count' => true,
			        'exclude'    => array( 1 ),
			        'hide_empty' => false,
			        'title_li'   => 'Top Categories'
			    ) ); ?>
			</ul>
			<ul class="sidebar-archives">
				<li class="archives-title">
				Archives
					<?php wp_get_archives( array(
				        'show_post_count' => true
				    ) ); ?>
			    </li>
			</ul>
		</div><!-- #sidebar -->
    </div>

<?php get_footer(); ?>
