<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Minnow
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<!-- Load Bootstrap -->
<?php wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/bootstrap/js/bootstrap.js', array( 'jquery' ) ); ?>
<?php wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css' ); ?>

<script src="https://use.typekit.net/vsk4nnk.js"></script>
<script>try{Typekit.load({ async: true });}catch(e){}</script>

<?php wp_head(); ?>

<!-- Load Mobile CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo bloginfo( 'template_directory' ) . '/mobile-blog.css'; ?>" />
<script>
/*  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');
  ga('create', 'UA-85604746-1', 'auto');
  ga('send', 'pageview');
  */
</script>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-85604746-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-85604746-1');
</script>
</head>

<body <?php body_class(); ?>>

<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'minnow' ); ?></a>

<div class="header container">
<div class="row">
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

	<header id="masthead" class="site-header" role="banner">

        <section id="utility_block">

        	<div class="col-lg-6 col-md-7 col-sm-7 col-xs-12">
            	<a href="/" id="logo"><img src="<?php echo bloginfo( 'template_directory' ) . '/img/blaising-logo.png'; ?>" alt="Steve Blaising" /></a>
        	</div>
        	<div class="col-lg-6 col-md-5 col-sm-5 col-xs-12">

                <div class="header-tools">
                    <div id="header-tools-dropdown" class="header-tools-item header-tools__subscribe-dropdown-container">
                        <a type="button" class="header-tools__subscribe lbp-inline-link-1" href="#">Subscribe</a>
                        <div style="display: none;">
                            <div id="lbp-inline-href-1" style="padding: 10px;background: #fff"><?php echo do_shortcode( '[contact-form-7 id="25" title="Contact form 1"]' ); ?></div>
                        </div>
                    </div><!--//#header-tools-dropdown-->
                    <div class="blaising">
                        <a href="http://www.steveblaising.com" class="blaising-triangle">steveblaising.com</a>
                    </div>
                </div> <!--//.header-tools-->
            </div> <!--//.col-->

        </section> <!--//#utility_block-->

		<?php if ( has_nav_menu ( 'social' ) ) : ?>
			<?php wp_nav_menu( array( 'theme_location' => 'social', 'depth' => 1, 'link_before' => '<span class="screen-reader-text">', 'link_after' => '</span>', 'container_class' => 'social-links', ) ); ?>
		<?php endif; ?>

		<?php if ( has_nav_menu ( 'primary' ) || is_active_sidebar( 'sidebar-1' ) ) : ?>
			<button class="menu-toggle" title="<?php esc_attr_e( 'Sidebar', 'minnow' ); ?>"><span class="screen-reader-text"><?php _e( 'Sidebar', 'minnow' ); ?></span></button>
		<?php endif; ?>
		<div class="slide-menu">
			<?php if ( has_nav_menu ( 'primary' ) ) : ?>
				<h2 class="widget-title"><?php _e( 'Menu', 'minnow' ); ?></h2>
				<nav id="site-navigation" class="main-navigation" role="navigation">
					<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
				</nav><!-- #site-navigation -->
			<?php endif; ?>

			<?php if ( is_active_sidebar( 'sidebar-1' ) ) {
				get_sidebar();
			} ?>
		</div> <!--//.slide-menu-->
	</header> <!-- #masthead -->

</div> <!--//.col-->
</div> <!--//.row-->
</div> <!--//.header container-->


<?php if ( is_front_page() || is_home() ) : ?>
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 no-padding">
            <section id="home-banner">
                <div class="fruitful-lines">
                    <h1><span class="first-letter-increase">F</span>ruitful <span class="first-letter-increase">L</span>ife</h1>
                    <h1><span class="first-letter-increase">F</span>ruitful <span class="first-letter-increase">W</span>ork</h1>
                </div>
                <h2>Welcome to the Blaising View blog, where I share treasures I find to enrich your life now.</h2>
            </section> <!-- home-banner -->
            </div> <!-- cols -->
        </div> <!-- row -->
    </div> <!-- container -->
<?php else : ?>
    <div class="container empty">
    </div>
<?php endif; ?>


<div id="content" class="site-content">

<div class="content container">
<div class="row">
<div class="main-content col-lg-10 col-md-10 col-sm-10 col-xs-12">
